/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.api.locations;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import net.minecraft.class_1937;

public class LocationsApi {
    private static final Map<String, BiFunction<class_1937, UUID, Map<UUID, LocationData>>> LOCATION_GETTERS = new HashMap<String, BiFunction<class_1937, UUID, Map<UUID, LocationData>>>();

    public static void addLocation(class_1937 level, UUID player, LocationData location) {
        TempadLocationHandler.addLocation(level, player, location);
    }

    public static void removeLocation(class_1937 level, UUID player, UUID location) {
        TempadLocationHandler.removeLocation(level, player, location);
    }

    public static void registerLocationGetter(String getterId, BiFunction<class_1937, UUID, Map<UUID, LocationData>> getter) {
        LOCATION_GETTERS.put(getterId, getter);
    }

    public static void gatherLocations(class_1937 level, UUID player, Map<UUID, LocationData> locations) {
        for (Map.Entry<String, BiFunction<class_1937, UUID, Map<UUID, LocationData>>> getter : LOCATION_GETTERS.entrySet()) {
            try {
                locations.putAll(getter.getValue().apply(level, player));
            }
            catch (Exception e) {
                Tempad.LOG.error("Error gathering locations from " + getter.getKey(), (Throwable)e);
            }
        }
    }
}

